projection=-Jl-100/35/33/45/0.3
region=-R-120.7/22.8/-63.7/47.7+r # +r makes the map square rather than weird shaped
gmt sphinterpolate 202412/20241203/t12z/nadocast_2024_preliminary_models_conus_sig_wind_20241203_t12z_f01-23.xyz -R-134/-61/21.2/52.5 -I2k -Q0 -G202412/20241203/t12z/nadocast_2024_preliminary_models_conus_sig_wind_20241203_t12z_f01-23.nc  # interpolate the xyz coordinates to a grid covering roughly the HRRR's area
gmt begin 202412/20241203/t12z/nadocast_2024_preliminary_models_conus_sig_wind_20241203_t12z_f01-23 pdf
gmt coast $region $projection -B+g240/245/255+n -ENA -Gc # Use the color of water for the background and begin clipping to north america
gmt grdimage 202412/20241203/t12z/nadocast_2024_preliminary_models_conus_sig_wind_20241203_t12z_f01-23.nc -nn $region $projection -C/home/brian/nadocast_dev/lib/sig_wind_hail_more_colors.cpt  # draw the predictions using the projection
gmt contour 202412/20241203/t12z/nadocast_2024_preliminary_models_conus_sig_wind_20241203_t12z_f01-23.xyz $region $projection -An -W0.4p+cl -C/home/brian/nadocast_dev/lib/sig_wind_hail_more_colors-dark.cpt # draw outlines around each contour
gmt coast -Q # stop clipping
gmt coast $region $projection -A500 -N2/thinnest -t65 # draw state borders 65% transparent
gmt coast $region $projection -A500 -N1 -Wthinnest -t45 # draw country borders and coastlines 45% transparent
gmt legend -Dx0.04i/0.04i+w1.7i+l1.3 -C0.03i/0.03i -F+gwhite+pthin << EOF
L 6pt,Helvetica-Bold C Nadocast Sigwind Day 2024-12-3 12Z
L 6pt,Helvetica C Valid 2024-12-3 12:30 UTC
L 6pt,Helvetica C Through 2024-12-4 11:30 UTC
L 4pt,Helvetica C HREF 12Z 
L 4pt,Helvetica C 2024_preliminary Models
L 4pt,Helvetica,gray C @_nadocast.com@_
EOF
gmt colorbar --FONT_ANNOT_PRIMARY=4p,Helvetica --MAP_FRAME_PEN=0i --MAP_TICK_LENGTH_PRIMARY=0i --MAP_TICK_PEN_PRIMARY=0 -Dn0.54/0.0695+w1.4i/0.1i+h -S -L0i -Np -C/home/brian/nadocast_dev/lib/sig_wind_hail_more_colors.cpt
echo '-95.55 27.93 Chance of 65+ knot t-storm wind within 25 miles of a point.' | gmt text $region $projection -F+f4p,Helvetica+jLB
gmt end
pdftoppm 202412/20241203/t12z/nadocast_2024_preliminary_models_conus_sig_wind_20241203_t12z_f01-23.pdf 202412/20241203/t12z/nadocast_2024_preliminary_models_conus_sig_wind_20241203_t12z_f01-23 -png -r 300 -singlefile
which pngquant && pngquant 64 --nofs --ext -quantized.png 202412/20241203/t12z/nadocast_2024_preliminary_models_conus_sig_wind_20241203_t12z_f01-23.png && rm 202412/20241203/t12z/nadocast_2024_preliminary_models_conus_sig_wind_20241203_t12z_f01-23.png && mv 202412/20241203/t12z/nadocast_2024_preliminary_models_conus_sig_wind_20241203_t12z_f01-23-quantized.png 202412/20241203/t12z/nadocast_2024_preliminary_models_conus_sig_wind_20241203_t12z_f01-23.png
which oxipng && oxipng  -o max --strip safe --libdeflater 202412/20241203/t12z/nadocast_2024_preliminary_models_conus_sig_wind_20241203_t12z_f01-23.png
rm 202412/20241203/t12z/nadocast_2024_preliminary_models_conus_sig_wind_20241203_t12z_f01-23.nc
rm 202412/20241203/t12z/nadocast_2024_preliminary_models_conus_sig_wind_20241203_t12z_f01-23.xyz
