projection=-Jl-100/35/33/45/0.3
region=-R-120.7/22.8/-63.7/47.7+r # +r makes the map square rather than weird shaped
gmt sphinterpolate 202410/20241005/t0z/nadocast_2024_preliminary_models_conus_tornado_20241005_t00z_f12-35.xyz -R-134/-61/21.2/52.5 -I2k -Q0 -G202410/20241005/t0z/nadocast_2024_preliminary_models_conus_tornado_20241005_t00z_f12-35.nc  # interpolate the xyz coordinates to a grid covering roughly the HRRR's area
gmt begin 202410/20241005/t0z/nadocast_2024_preliminary_models_conus_tornado_20241005_t00z_f12-35 pdf
gmt coast $region $projection -B+g240/245/255+n -ENA -Gc # Use the color of water for the background and begin clipping to north america
gmt grdimage 202410/20241005/t0z/nadocast_2024_preliminary_models_conus_tornado_20241005_t00z_f12-35.nc -nn $region $projection -C/home/brian/nadocast_dev/lib/tornado_colors.cpt  # draw the predictions using the projection
gmt contour 202410/20241005/t0z/nadocast_2024_preliminary_models_conus_tornado_20241005_t00z_f12-35.xyz $region $projection -An -W0.4p+cl -C/home/brian/nadocast_dev/lib/tornado_colors-dark.cpt # draw outlines around each contour
# Dump contour to file, then draw it as a polygon
gmt contour 202410/20241005/t0z/nadocast_2024_preliminary_models_conus_tornado_20241005_t00z_f12-35-sig.xyz $region $projection -C/home/brian/nadocast_dev/lib/sig_colors.cpt -D202410/20241005/t0z/nadocast_2024_preliminary_models_conus_tornado_20241005_t00z_f12-35-sig_contour.xy
gmt psxy 202410/20241005/t0z/nadocast_2024_preliminary_models_conus_tornado_20241005_t00z_f12-35-sig_contour.xy $region $projection -Gp26+b-+r800 # pattern fill
gmt psxy 202410/20241005/t0z/nadocast_2024_preliminary_models_conus_tornado_20241005_t00z_f12-35-sig_contour.xy $region $projection -W0.5p # pen, width 0.5pt
gmt coast -Q # stop clipping
gmt coast $region $projection -A500 -N2/thinnest -t65 # draw state borders 65% transparent
gmt coast $region $projection -A500 -N1 -Wthinnest -t45 # draw country borders and coastlines 45% transparent
gmt legend -Dx0.04i/0.04i+w1.7i+l1.3 -C0.03i/0.03i -F+gwhite+pthin << EOF
L 7pt,Helvetica-Bold C Nadocast Tor Day 2024-10-5 0Z
L 6pt,Helvetica C Valid 2024-10-5 11:30 UTC
L 6pt,Helvetica C Through 2024-10-6 11:30 UTC
L 4pt,Helvetica C HREF 0Z 
L 4pt,Helvetica C 2024_preliminary Models
L 4pt,Helvetica,gray C @_nadocast.com@_
EOF
gmt colorbar --FONT_ANNOT_PRIMARY=4p,Helvetica --MAP_FRAME_PEN=0i --MAP_TICK_LENGTH_PRIMARY=0i --MAP_TICK_PEN_PRIMARY=0 -Dn0.54/0.0695+w1.4i/0.1i+h -S -L0i -Np -C/home/brian/nadocast_dev/lib/tornado_colors.cpt
echo '-95.55 27.93 Chance of a tornado within 25 miles of a point.' | gmt text $region $projection -F+f4p,Helvetica+jLB
echo '-95.65 25.35 Black hatched = 10%+ chance of EF2+' | gmt text $region $projection -F+f4p,Helvetica+jLB
gmt end
pdftoppm 202410/20241005/t0z/nadocast_2024_preliminary_models_conus_tornado_20241005_t00z_f12-35.pdf 202410/20241005/t0z/nadocast_2024_preliminary_models_conus_tornado_20241005_t00z_f12-35 -png -r 300 -singlefile
which pngquant && pngquant 64 --nofs --ext -quantized.png 202410/20241005/t0z/nadocast_2024_preliminary_models_conus_tornado_20241005_t00z_f12-35.png && rm 202410/20241005/t0z/nadocast_2024_preliminary_models_conus_tornado_20241005_t00z_f12-35.png && mv 202410/20241005/t0z/nadocast_2024_preliminary_models_conus_tornado_20241005_t00z_f12-35-quantized.png 202410/20241005/t0z/nadocast_2024_preliminary_models_conus_tornado_20241005_t00z_f12-35.png
which oxipng && oxipng  -o max --strip safe --libdeflater 202410/20241005/t0z/nadocast_2024_preliminary_models_conus_tornado_20241005_t00z_f12-35.png
rm 202410/20241005/t0z/nadocast_2024_preliminary_models_conus_tornado_20241005_t00z_f12-35.nc
rm 202410/20241005/t0z/nadocast_2024_preliminary_models_conus_tornado_20241005_t00z_f12-35.xyz
rm 202410/20241005/t0z/nadocast_2024_preliminary_models_conus_tornado_20241005_t00z_f12-35-sig.xyz
rm 202410/20241005/t0z/nadocast_2024_preliminary_models_conus_tornado_20241005_t00z_f12-35-sig_contour.xy
