projection=-Jl-100/35/33/45/0.3
region=-R-120.7/22.8/-63.7/47.7+r # +r makes the map square rather than weird shaped
gmt sphinterpolate 202211/20221113/t12z/nadocast_conus_hail_20221113_t12z_f24-47.xyz -R-134/-61/21.2/52.5 -I2k -Q0 -G202211/20221113/t12z/nadocast_conus_hail_20221113_t12z_f24-47.nc  # interpolate the xyz coordinates to a grid covering roughly the HRRR's area
gmt begin 202211/20221113/t12z/nadocast_conus_hail_20221113_t12z_f24-47 pdf
gmt coast $region $projection -B+g240/245/255+n -ENA -Gc # Use the color of water for the background and begin clipping to north america
gmt grdimage 202211/20221113/t12z/nadocast_conus_hail_20221113_t12z_f24-47.nc -nn $region $projection -C/home/brian/nadocast_operational_2021/lib/wind_hail_colors.cpt  # draw the predictions using the projection
gmt contour 202211/20221113/t12z/nadocast_conus_hail_20221113_t12z_f24-47.xyz $region $projection -An -W0.4p+cl -C/home/brian/nadocast_operational_2021/lib/wind_hail_colors-dark.cpt # draw outlines around each contour
# Dump contour to file, then draw it as a polygon
gmt contour 202211/20221113/t12z/nadocast_conus_hail_20221113_t12z_f24-47-sig.xyz $region $projection -C/home/brian/nadocast_operational_2021/lib/sig_colors.cpt -D202211/20221113/t12z/nadocast_conus_hail_20221113_t12z_f24-47-sig_contour.xy
gmt psxy 202211/20221113/t12z/nadocast_conus_hail_20221113_t12z_f24-47-sig_contour.xy $region $projection -Gp26+b-+r800 # pattern fill
gmt psxy 202211/20221113/t12z/nadocast_conus_hail_20221113_t12z_f24-47-sig_contour.xy $region $projection -W0.5p # pen, width 0.5pt
gmt coast -Q # stop clipping
gmt coast $region $projection -A500 -N2/thinnest -t65 # draw state borders 65% transparent
gmt coast $region $projection -A500 -N1 -Wthinnest -t45 # draw country borders and coastlines 45% transparent
gmt legend -Dx0.04i/0.04i+w1.7i+l1.3 -C0.03i/0.03i -F+gwhite+pthin << EOF
L 6pt,Helvetica-Bold C Nadocast Hail 12Z Day 2 for 2022-11-14
L 6pt,Helvetica C Valid 2022-11-14 11:30 UTC
L 6pt,Helvetica C Through 2022-11-15 11:30 UTC
L 4pt,Helvetica C HREF 12Z 
L 4pt,Helvetica C 2021 Models
L 4pt,Helvetica,gray C @_nadocast.com@_
EOF
gmt colorbar --FONT_ANNOT_PRIMARY=4p,Helvetica --MAP_FRAME_PEN=0i --MAP_TICK_LENGTH_PRIMARY=0i --MAP_TICK_PEN_PRIMARY=0 -Dn0.54/0.0695+w1.4i/0.1i+h -S -L0i -Np -C/home/brian/nadocast_operational_2021/lib/wind_hail_colors.cpt
echo '-95.55 27.93 Chance of 1+ inch hail within 25 miles of a point.' | gmt text $region $projection -F+f4p,Helvetica+jLB
echo '-95.65 25.35 Black hatched = 10%+ chance of 2in+' | gmt text $region $projection -F+f4p,Helvetica+jLB
gmt end
pdftoppm 202211/20221113/t12z/nadocast_conus_hail_20221113_t12z_f24-47.pdf 202211/20221113/t12z/nadocast_conus_hail_20221113_t12z_f24-47 -png -r 300 -singlefile
which pngquant && pngquant 64 --nofs --ext -quantized.png 202211/20221113/t12z/nadocast_conus_hail_20221113_t12z_f24-47.png && rm 202211/20221113/t12z/nadocast_conus_hail_20221113_t12z_f24-47.png && mv 202211/20221113/t12z/nadocast_conus_hail_20221113_t12z_f24-47-quantized.png 202211/20221113/t12z/nadocast_conus_hail_20221113_t12z_f24-47.png
which oxipng && oxipng  -o max --strip safe --libdeflater 202211/20221113/t12z/nadocast_conus_hail_20221113_t12z_f24-47.png
rm 202211/20221113/t12z/nadocast_conus_hail_20221113_t12z_f24-47.nc
rm 202211/20221113/t12z/nadocast_conus_hail_20221113_t12z_f24-47.xyz
rm 202211/20221113/t12z/nadocast_conus_hail_20221113_t12z_f24-47-sig.xyz
rm 202211/20221113/t12z/nadocast_conus_hail_20221113_t12z_f24-47-sig_contour.xy
